﻿<%@ Page Language="c#" AutoEventWireup="false" CodePage="1200" %>

<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>

<%@ Import Namespace="System.Collections.Generic" %>
<%@ Import Namespace="Soneta.Ksiega" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Tools" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Księga Przychodów i Rozchodów</title>
	<script runat="server">

		public class Params : ContextBase
		{
			private OkresObrachunkowy okresObrachunkowy;
			private Boolean dowolnyOkres = false;
			private FromTo okres;

			private OkresObrachunkowy fstOkres = null;
			private OkresObrachunkowy lstOkres = null;
			private FromTo maxOkres;


			public Params(Context context)
				: base(context)
			{
				OkresyObrach tblOkresy = KsiegaModule.GetInstance(this).OkresyObrach;
				if (tblOkresy.IsEmpty) throw new ApplicationException("Brak okresów obrachunkowych");

				foreach (OkresObrachunkowy okr in tblOkresy.WgOkresu.CreateView())
				{
					if (fstOkres == null)
						fstOkres = okr;
					lstOkres = okr;
				}

				maxOkres = new FromTo(fstOkres.Okres.From, lstOkres.Okres.To);
				okresObrachunkowy = (OkresObrachunkowy)context[typeof(OkresObrachunkowy)];
				recalcOkres();
			}


			private void recalcOkres()
			{
				if (!dowolnyOkres)
					okres = okresObrachunkowy.Okres;
				else if (okres == FromTo.Empty)
					okres = FromTo.All;

				okres = okres.Intersection(maxOkres);
				if (okres == FromTo.Empty) okres = maxOkres;

				okres = new FromTo(okres.From.FirstDayMonth(), okres.To.LastDayMonth());

				OnChanged(EventArgs.Empty);
			}


			[Priority(10)]
			[Caption("Roczne")]
			public OkresObrachunkowy OkresObrachunkowy
			{
				get { return okresObrachunkowy; }
				set
				{
					okresObrachunkowy = value != null ? value : lstOkres;
					recalcOkres();
				}
			}


			[Priority(20)]
			[Caption("Dowolny okres")]
			public Boolean DowolnyOkres
			{
				get { return dowolnyOkres; }
				set
				{
					dowolnyOkres = value;
					recalcOkres();
				}
			}


			[Required]
			[Priority(30)]
			[Caption("Za okres")]
			public FromTo Okres
			{
				get { return okres; }
				set
				{
					okres = value;
					recalcOkres();
				}
			}


			public Boolean IsReadOnlyOkresObrachunkowy()
			{ return dowolnyOkres; }

			public Boolean IsReadOnlyOkres()
			{ return !dowolnyOkres; }
		}


		private Params pars;


		[Context]
		public Params Pars
		{
			get { return pars; }
			set { pars = value; }
		}


		public class PodsumowanieItem
		{
			YearMonth podsumMiesiac;

			Currency podsumK07 = 0m;
			Currency podsumK08 = 0m;
			Currency podsumK09 = 0m;
			Currency podsumK10 = 0m;
			Currency podsumK11 = 0m;
			Currency podsumK13 = 0m;
			Currency podsumK14 = 0m;
			Currency podsumK15 = 0m;
			Currency podsumK16 = 0m;
			Currency podsumK17 = 0m;
			Boolean remanent = false;

			public PodsumowanieItem(YearMonth mies)
			{
				podsumMiesiac = mies;
			}

			public YearMonth PodsumMiesiac
			{
				get { return podsumMiesiac; }
				set { podsumMiesiac = value; }
			}

			public Currency PodsumK07
			{
				get { return podsumK07; }
				set { podsumK07 = value; }
			}

			public Currency PodsumK08
			{
				get { return podsumK08; }
				set { podsumK08 = value; }
			}

			public Currency PodsumK09
			{
				get { return podsumK09; }
				set { podsumK09 = value; }
			}

			public Currency PodsumK10
			{
				get { return podsumK10; }
				set { podsumK10 = value; }
			}

			public Currency PodsumK11
			{
				get { return podsumK11; }
				set { podsumK11 = value; }
			}

			public Currency PodsumK13
			{
				get { return podsumK13; }
				set { podsumK13 = value; }
			}

			public Currency PodsumK14
			{
				get { return podsumK14; }
				set { podsumK14 = value; }
			}

			public Currency PodsumK15
			{
				get { return podsumK15; }
				set { podsumK15 = value; }
			}

			public Currency PodsumK16
			{
				get { return podsumK16; }
				set { podsumK16 = value; }
			}

            public Currency PodsumK17
			{
				get { return podsumK17; }
				set { podsumK17 = value; }
			}

			public Boolean Remanent
			{
				get { return remanent; }
				set { remanent = value; }
			}
		}


		private void dc_ContextLoad(Object sender, EventArgs e)
		{
			FromTo okresWydruku = pars.Okres;

			KsiegaModule ksiega = KsiegaModule.GetInstance(dc.Context);
			Soneta.Business.View view = ksiega.Dziennik.WgKPiR.CreateView();

			if (pars.DowolnyOkres)
			{
				ReportHeader["TYPOKRESU"] = "okres";
				ReportHeader["OKRES"] = String.Format("{0} .. {1}", okresWydruku.From.ToYearMonth(), okresWydruku.To.ToYearMonth());
				ReportHeader["TYP"] = "okresowe";

				view.Condition &= new FieldCondition.Contain("Data", okresWydruku);
				view.Condition &= "KPiR.Lp>0";
			}
			else
			{
				ReportHeader["TYPOKRESU"] = "rok";
				ReportHeader["OKRES"] = Pars.OkresObrachunkowy.ToString();
				ReportHeader["TYP"] = "roczne";

				view.Condition &= new FieldCondition.Equal("Okres", pars.OkresObrachunkowy);
				view.Condition &= "KPiR.Lp>0";
			}

			List<PodsumowanieItem> lst = new List<PodsumowanieItem>();
			for (YearMonth ym = okresWydruku.From.ToYearMonth(); ym <= okresWydruku.To.ToYearMonth(); ym = ym.AddMonths(1))
				lst.Add(new PodsumowanieItem(ym));

			KPiR.KPiRWorker worker = new KPiR.KPiRWorker();

			foreach (DekretBase dekret in view)
			{
				if (dekret.KPiR.Stan == StanyZapisuKPiR.Przekreślony)
					continue;
				if (dekret.Data < okresWydruku.From || dekret.Data > okresWydruku.To)
					continue;

				worker.Dekret = dekret;

				foreach (PodsumowanieItem pods in lst)
					if (dekret.Data.ToYearMonth().Equals(pods.PodsumMiesiac))
					{
						pods.PodsumK07 += worker.K07;
						pods.PodsumK08 += worker.K08;
						pods.PodsumK09 += worker.K09;
						pods.PodsumK10 += worker.K10;
						pods.PodsumK11 += worker.K11;
						pods.PodsumK13 += worker.K13;
						pods.PodsumK14 += worker.K14;
						pods.PodsumK15 += worker.K15;
						pods.PodsumK16 += worker.K16;
						pods.PodsumK17 += worker.K17;

						if (worker.Remanent)
							pods.Remanent = true;
						break;
					}
			}

			Grid.DataSource = lst;
		}


		private void Grid_BeforeRow(object sender, Soneta.Web.RowEventArgs args)
		{
			PodsumowanieItem item = (PodsumowanieItem)args.Row;

			SetCol(colMiesiac, item.PodsumMiesiac.ToString(), true);
			SetCol(col07, item.PodsumK07.Value, true);
			SetCol(col08, item.PodsumK08.Value, true);
			SetCol(col09, item.PodsumK09.Value, true);
			SetCol(col10, item.PodsumK10.Value, true);
			SetCol(col11, item.PodsumK11.Value, true);
			SetCol(col13, item.PodsumK13.Value, true);
			SetCol(col14, item.PodsumK14.Value, true);
			SetCol(col15, item.PodsumK15.Value, true);
			SetCol(col16, item.PodsumK16.Value, true);
			SetCol(col17, item.PodsumK17.Value, true);

			col16.HideZero = ! item.Remanent;
		}


		private void SetCol(Soneta.Web.GridColumn col, decimal value, bool sum)
		{
			col.SumRow = sum;
			if (sum || value != 0)
			{
				col.Format = "{0:n}";
				col.EditValue = value;
			}
			else
				col.Format = "<center>-------------</center>";
		}



		private void SetCol(Soneta.Web.GridColumn col, string value, bool sum)
		{
			col.SumRow = sum;
			if (sum)
			{
				col.Format = "{0:n}";
				col.EditValue = value;
			}
			else
				col.Format = "<center>-------------</center>";
		}
		    		    
	</script>
</head>
<body>
	<form id="Form1" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" TopMargin="10" BottomMargin="10" LeftMargin="10" Landscape="True" OnContextLoad="dc_ContextLoad" />
	<eb:ReportHeader ID="ReportHeader" Title="PODATKOWA  KSIĘGA PRZYCHODÓW I ROZCHODÓW|Zestawienie %TYP%|Za %TYPOKRESU% %OKRES%" runat="server" />
	<ea:Grid ID="Grid" runat="server" ShowPrevAgrSum="InFooter" ShowPageSum="True" OnBeforeRow="Grid_BeforeRow" ShowAgrSum="True">
		<Columns>
			<ea:GridColumn Width="4" Align="Center" DataMember="#" Caption="Lp" runat="server" EncodeHTML="True" />
			<ea:GridColumn Align="Center" Total="Info" Caption="Miesiąc" ID="colMiesiac" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Wartość sprzedanych towar&#243;w i usług&lt;br&gt;&lt;br&gt;&lt;br&gt;(07)" HideZero="True" Format="{0:0.00}" ID="col07" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Pozostałe przychody&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;(08)" HideZero="True" Format="{0:0.00}" ID="col08" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Razem przych&#243;d&lt;br&gt;&lt;br&gt;(7+8)&lt;br&gt;&lt;br&gt;&lt;br&gt;(09)" HideZero="True" Format="{0:0.00}" ID="col09" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Zakup towar&#243;w handlowych i materiał&#243;w wg cen zakupu&lt;br&gt;&lt;br&gt;(10)" HideZero="True" Format="{0:0.00}" ID="col10" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Koszty uboczne zakupu&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;(11)" HideZero="True" Format="{0:0.00}" ID="col11" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Wynagro-&lt;br&gt;dzenia w got&#243;wce i w naturze&lt;br&gt;&lt;br&gt;&lt;br&gt;(12)" HideZero="True" Format="{0:0.00}" ID="col13" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Pozostałe wydatki&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;(13)" HideZero="True" Format="{0:0.00}" ID="col14" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="Razem wydatki&lt;br&gt;&lt;br&gt;(12+13)&lt;br&gt;&lt;br&gt;&lt;br&gt;(14)" HideZero="True" Format="{0:0.00}" ID="col15" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Caption="&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;&lt;br&gt;(15)" HideZero="True" Format="{0:0.00}" ID="col16" runat="server" />
			<ea:GridColumn Width="14" Align="Right" Total="Sum" Caption="&lt;br&gt;Koszty&lt;br&gt;działalności&lt;br&gt;badawczo&lt;br&gt;rozwojowej&lt;br&gt;art. 26e&lt;br&gt;ustawy&lt;br&gt;(16)" HideZero="True" Format="{0:0.00}" ID="col17" runat="server" />
		</Columns>
	</ea:Grid>
	<eb:ReportFooter ID="ReportFooter" runat="server" />
	</form>
</body>
</html>
